/**
* \file: AilAudioConfig.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Configuration of AilAudioSink and AilAudioSource classes
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_AILAUDIOCONFIG_H
#define BDCL_AILAUDIOCONFIG_H

#include <uspi/ConfigHandle.h>

namespace adit { namespace bdcl {

/* According to Baidu Spec: NAVI TTS, VR TTS, VR MIC have mono channel; MEDIA has stereo channel per default */
#define AUDIO_CHANNEL_MONO              1
#define AUDIO_CHANNEL_STEREO            2

/* According to Baidu Spec: NAVI TTS, VR TTS, VR MIC, MEDIA have 16 bits per sample */
// todo use internally, do not make mSampleFormat configurable
#define AUDIO_SAMPLE_FORMAT_16_BITS     16

/* According to Baidu Spec: NAVI TTS, VR TTS, VR MIC have 16kHz; MEDIA has 44.1kHz per default */
#define AUDIO_SAMPLE_RATE_16_KHZ        16000
#define AUDIO_SAMPLE_RATE_44_1_KHZ      44100

/* Default duration for one period in jitter buffer (in ms) */
#define AUDIO_DEFAULT_PERIOD_MS         8

class AilAudioSinkConfig : public uspi::ConfigHandle
{
public:
    AilAudioSinkConfig() : mDeviceName(""), mStreamType(""), mBufferMinMs(0), mBufferMaxMs(0), //mFlushBuffer(false),
    mDisablePrio(false), mThreadPrio(0), mInitToutMs(0), mPeriodMs(0), mNumofChannels(0), mSampleFormat(0),
    mSampleRate(0) { }

    bool ResultConfig()
    {
        bool is_valid = true;

        mDeviceName = getStringMultiKey("audio-playback-device", "device", &is_valid, Range(-1, -1));
        // todo actually use it to configure AIL
        mInitToutMs = getIntMultiKey("audio-playback-device", "inittoutms", &is_valid, Range(0, INT_MAX), 500);
        mPeriodMs = getIntMultiKey("audio-playback-device", "periodms", &is_valid, Range(0, INT_MAX), AUDIO_DEFAULT_PERIOD_MS);

        mStreamType = getString("audio-sink-stream-type", &is_valid,
                MatchStrings(3, "AUDIO_STREAM_MEDIA", "AUDIO_STREAM_NAVI_TTS", "AUDIO_STREAM_VR_TTS"));

        // todo the following two lines have magic default values, set proper ones
        mBufferMinMs = getInt("audio-sink-threshold-ms", &is_valid, Range(0, INT_MAX), 100);
        mBufferMaxMs = getInt("audio-sink-buffer-max-ms", &is_valid, Range(0, INT_MAX), 20000); //based on MC's reply value set to 20000
//        mFlushBuffer = getInt("flush-buffer", &is_valid, Match(2, 0, 1), 0);

        mDisablePrio = getInt("disable-real-time-priority-audio", &is_valid, Match(2, 0, 1), 0);
        mThreadPrio  = getInt("audio-threads-real-time-priority", &is_valid, Range(0, INT_MAX), 61);

        mNumofChannels = getInt("audio-sink-channels", &is_valid, Match(2, AUDIO_CHANNEL_MONO, AUDIO_CHANNEL_STEREO),
                AUDIO_CHANNEL_MONO);
        mSampleFormat = getInt("audio-sink-bits-per-sample", &is_valid, Range(0, INT_MAX), AUDIO_SAMPLE_FORMAT_16_BITS);
        mSampleRate = getInt("audio-sink-sampling-rate", &is_valid, Range(0, INT_MAX), AUDIO_SAMPLE_RATE_16_KHZ);

        mAudioRecord     = getIntMultiKey("audio-sink-record", "enable", &is_valid, Range(-1, 1), 0);
        mAudioRecordFile = getStringMultiKey("audio-sink-record", "filename", &is_valid, Range(-1, INT_MAX), "");

        return is_valid;
    }

    std::string mDeviceName;
    std::string mStreamType;

    unsigned int mBufferMinMs;
    unsigned int mBufferMaxMs;
//    bool mFlushBuffer;

    bool mDisablePrio;
    int mThreadPrio;

    int mInitToutMs;
    int mPeriodMs;

    int mNumofChannels;
    int mSampleFormat;
    int mSampleRate;

    /* Enable record of received audio data */
    int     mAudioRecord;
    string  mAudioRecordFile;
};

class AilAudioSourceConfig : public uspi::ConfigHandle
{
public:
    AilAudioSourceConfig() : mDeviceName(""), mDisablePrio(false), mThreadPrio(0), mInitToutMs(0), mNumofChannels(0),
    mSampleFormat(0), mSampleRate(0) { }

    bool ResultConfig()
    {
        bool is_valid = true;

        mDeviceName = getStringMultiKey("audio-capture-device", "device", &is_valid, Range(-1, -1));
        // todo actually use it to configure AIL
        mInitToutMs = getIntMultiKey("audio-capture-device", "inittoutms", &is_valid, Range(0, INT_MAX), 500);
        mPeriodMs = getIntMultiKey("audio-capture-device", "periodms", &is_valid, Range(-1, INT_MAX), AUDIO_DEFAULT_PERIOD_MS);

        mDisablePrio = getInt("disable-real-time-priority-audio", &is_valid, Match(2, 0, 1), 0);
        mThreadPrio  = getInt("audio-threads-real-time-priority", &is_valid, Range(0, INT_MAX), 61);

        mNumofChannels = getInt("audio-source-channels", &is_valid, Match(2, AUDIO_CHANNEL_MONO, AUDIO_CHANNEL_STEREO),
                AUDIO_CHANNEL_MONO);
        mSampleFormat = getInt("audio-source-bits-per-sample", &is_valid, Range(0, INT_MAX), AUDIO_SAMPLE_FORMAT_16_BITS);
        mSampleRate = getInt("audio-source-sampling-rate", &is_valid, Range(0, INT_MAX), AUDIO_SAMPLE_RATE_16_KHZ);

        return is_valid;
    }

    std::string mDeviceName;

    bool mDisablePrio;
    int mThreadPrio;

    int mInitToutMs;
    int mPeriodMs;

    int mNumofChannels;
    int mSampleFormat;
    int mSampleRate;
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_AILAUDIOCONFIG_H */
